/*
 * json_utils.h
 *
 *  Created on: Aug 21, 2014
 *      Author: kl81hc
 */

#ifndef JSON_UTILS_op_H_
#define JSON_UTILS_op_H_

#define   _NEW_JSON
#include "json.h"
#undef _NEW_JSON

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include <stl_pif.h>

class json_utils {
public:
	json_utils();
	~json_utils();

	/*Carwings Date JSON object names*/
	static tCString U16_YEAR;
	static tCString U8_MONTH;
	static tCString U8_DAY;
	static tCString U8_HOUR;
	static tCString U8_MINUTES;
	static tCString U8_SECOND;

	/*Carwings File Header JSON object names*/
	static tCString EXPIRY_DATE;
	static tCString FILE_HEADER;

	/*Constant JSON object name*/
	static tCString FID;
	static tCString METHOD_NAME;
	static tCString CHANNEL_MASTER_DATA;
	static tCString CHANNEL_CMD_HEADER;
	static tCString U8_NUM_OF_FOLDER_DEF_INFO;
	static tCString U16_NUM_OF_CHANNEL_DEF_INFO;
	static tCString FOLDER_DEFINITION_INFORMATION;
	static tCString U16_FOLDER_ID;
	static tCString U8_MENU_CTRL_FLAG;
	static tCString U8_CHANNEL_GEN_MODE_ID;
	static tCString DISTRIBUTION_STARTDATE;
	static tCString DISTRIBUTION_ENDDATE;
	static tCString U8_CHANNEL_FLAG;
	static tCString U8_BTN_DISPLAY_CTRL_FLAG;
	static tCString STR_FOLDER_NAME;
	static tCString STR_FOLDER_NAME_FOR_TTS;
	static tCString U16_FOLDER_ICON_ID;
	static tCString CHANNEL_DEFINITION_INFORMATION;
	static tCString U16_CHANNEL_ID;
	static tCString U8_CHANNEL_CONTENT_ID;
	static tCString STR_CHANNEL_NAME;
	static tCString STR_CHANNEL_NAME_FOR_TTS;
	static tCString U8_CHANNEL_ACTION_SWID;
	static tCString U32_CHANNEL_ACTION_SW_PARAM;
	static tCString STR_CHANNEL_ACTION_SW_NAME;
	static tCString U8_MOVING_RESTRICTION_FLAG_CTRL;
	static tCString U8_NUMBER_OF_DATA_CONTENTS_PER_ONCE;
	static tCString U8_TOTAL_NUM_OF_DATA_CONTENTS;
	static tCString U16_CHANNEL_ICON_ID;
	static tCString U8_FLAG_OF_CHANNEL_INFO;
	static tCString CHANNEL_INFO_LIST;
	static tCString CHANNEL_DATA;
	static tCString CHANNEL_DATA_INFO_HEADER_PART;
	static tCString U8_CHANNEL_INFO_TYPE;
	static tCString U8_NUM_OF_CHANNEL_CONTENTS;
	static tCString AUTO_PLAY_U8_NUM_OF_CHANNEL_CONTENTS;
	static tCString U8_NUM_OF_EXEC_INFO;
	static tCString U8_NUM_OF_CHANNEL_CONTENTS_AT_ONE_TIME;
	static tCString U8_TOTAL_NUM_OF_CHANNEL_CONTENTS;
	static tCString CHANNEL_DATA_INFORMATION_RECORD_PART;
	static tCString U8_CHANNEL_CONTENT_TYPE;
	static tCString U8_CHANNEL_CONTENTS_ID;
	static tCString STR_TITLE;
	static tCString STR_TITLE_FOR_TTS;
	static tCString LOCATION;
	static tCString U8_DIRECTION;
	static tCString U8_LONGITUDE_DEGREE;
	static tCString U8_LONGITUDE_MINUTE;
	static tCString U16_LONGITUDE_SECOND;
	static tCString U8_LATITUDE_DEGREE;
	static tCString U8_LATITUDE_MINUTE;
	static tCString U16_LATITUDE_SECOND;
	static tCString U8_LOCATION_ATTRIBUTE;
	static tCString U8_DEST_OR_WAYPOINT_TYPE;
	static tCString STR_ADDRESS;
	static tCString STR_PHONE_NUMBER;
	static tCString STR_PHONE_NUMBER_FOR_DISP;
	static tCString STR_MAIL_ADDRESS;
	static tCString STR_NICKNAME;
	static tCString STR_TEXT;
	static tCString STR_TEXT_FOR_TTS;
	static tCString U16_ICON_ID;
	static tCString U16_SOUNDID_FOR_BEGINNING_OF_PLAY;
	static tCString U16_SE_INFO;
	static tCString U16_SOUNDID_FOR_BGM;
	static tCString U8_ACTION_SWID;
	static tCString U32_PARAMETEROF_ACTION_SW;
	static tCString U8_FLAG_OF_DISP_BUTTON_CTRL;
	static tCString U8_FLAG_OF_CTRL_DURING_RUNNING;
	static tCString STR_NAME_OF_IMAGE_BUTTON;
	static tCString STR_NAME_OF_ACTION_SW;
	static tCString U8_FLAG_OF_EXEC_OF_CHANNEL_CONTENTS;
	static tCString U8_FLAG_OF_STORING_CTRL;
	static tCString U8_IMAGE_AVAILABILITY;
	static tCString STR_IMAGE_LOCATION;
	static tCString EXECUTION_INFORMATION;
	static tCString U8_EXEC_TYPE;
	static tCString EXECTION_DETAILS;
	static tCString ROUTE_CALC;
	static tCString EXEC_TYPE_CALL;
	static tCString EXEC_TYPE_AUTODJ_EXEC;
	static tCString EXEC_TYPE_OPERATOR_CALL;
	static tCString EXEC_TYPE_AUTOPLAY_WITH_MAPPOINT;
	static tCString SECTION_TYPE;
	static tCString CONDITION_OF_ROUTECALC_ALL_SECTION_OR_SECTION_1;
	static tCString CONDITION_OF_ROUTE_CALC_SECTION_2;
	static tCString CONDITION_OF_ROUTE_CALC_SECTION_3;
	static tCString CONDITION_OF_ROUTE_CALC_SECTION_4;
	static tCString CONDITION_OF_ROUTE_CALC_SECTION_5;
	static tCString CONDITION_OF_ROUTE_CALC_SECTION_6;
	static tCString U16_VICS_RTIC_SETTING;
	static tCString DISPLIST;
	static tCString CW_SETTING;
	static tCString NUM_OF_CHANNEL_CONTENTS;
	static tCString U8_NUM_OF_TARGET_AUTODJ_CHANNELNO;
	static tCString U16_LIST_OF_TARGET_AUTODJ_CHANNELNO;
	static tCString U8_LOCATION_TO_DISPLAY;
	static tCString U8_MAP_DISPLAY_SCALE;
	static tCString U8_LIST_OF_CHANNEL_CONTENTS;
	static tCString CHANNEL_CONTENTS_ID;
	static tCString AUTO_PLAY;
	static tCString FAVORITE_CHANNEL_LIST;
	static tCString U8_NUM_OF_FAVORITE_CHANNEL_LIST;
	static tCString FAVORITE_CHANNEL_LIST_RECORD;
	static tCString U8_FAVORITE_CHANNEL_LIST_ID;
	static tCString U8_SETTING_MODE;
	static tCString U16_CITY_BROWSER_START_SERVICEID;

	static tCString CONNECTED_SEARCH;
	static tCString CONNECTED_SEARCH_U8_NUM_OF_POI;
	static tCString CONNECTED_SEARCH_DATA_RECORD;
	static tCString CONNECTED_SEARCH_STR_POI_NAME;
	static tCString CONNECTED_SEARCH_STR_ADDRESS;
	static tCString CONNECTED_SEARCH_STR_PHONE_NUMBER;
	static tCString CONNECTED_SEARCH_STR_PHONE_NUMBER_FOR_DISP;
	static tCString CONNECTED_SEARCH_STR_CATEGORY;

	static tCString DATA_CONNECTION_ERROR;
	static tCString ERROR_REQUEST_TYPE;

	static tCString DTC_CONNECTION_STATUS;
	static tCString DATA_CONNECTION_STATUS;

	static tCString SERVER_LIST;
	static tCString RESPONSE_LIST;
	static tCString SERVER_LIST_U8_SERVER_ID;
	static tCString SERVER_LIST_STR_SERVER_NAME;
	static tCString SERVER_LIST_STR_SERVER_ADDRESS;
	static tCString SERVER_LIST_U8_CURRENT_SERVER;

	static tCString GENERAL_NOTIFICATION_MESSAGE;
	static tCString U8_NOTI_RESULT;
	static tCString STR_DISPLAY_MESSAGE;
	static tCString STR_TTS_TEXT_MESSAGE;
	static tCString ICON_LIST;
	static tCString ICON_ID;
	static tCString ICON_DATA_TYPE;
	static tCString ICON_FOR_MAP_DAY_TIME;
	static tCString ICON_FOR_MENU_DAY_TIME;
	static tCString ICON_FOR_MAP_NIGHT;
	static tCString ICON_FOR_MENU_NIGHT;
	//General Response
	static tCString GENERAL_RESPONSE;
	static tCString REQUEST_ID;
	static tCString RESPONSE_ID;
	//Probe JSON Datatypes
	static tCString PROBE_CONFIGURATION;
	static tCString ANALYSISCODE;
	static tCString CONFIGURATIONVERSION;
	static tCString FUNCTIONCODE;
	static tCString REMOTESENDINGSIZE;
	static tCString TRACKING;
	static tCString CALCULATED;
	static tCString MATSUSHITACOMPRESSION;
	static tCString ACQUISITIONDEFINITION;
	static tCString NAVIINFORMATION;
	static tCString LABEL;
	static tCString STORETRIGGER;
	static tCString STOREINTERVAL;
	static tCString DATATHINNING;
	static tCString DATAINTERVAL;
	static tCString CALCULATEDINFORMATION;
	static tCString REMOTESENDINGFLAG;
	static tCString THRESHOLD;
	static tCString THRESHOLD1;
	static tCString TYPE;
	static tCString DATA;
	static tCString THRESHOLD2;
	static tCString THRESHOLD3;
	static tCString YEAR;
	static tCString MONTH;
	static tCString DAY;
	static tCString TIME;
	static tCString MINUTE;
	static tCString SECOND;
	static tCString TIMESOZNE;
	static tCString LATITUDE;
	static tCString LONGITUDE;
	static tCString TRIPFUELINJECTIONQUANTITY;
	static tCString MILEAGECOVEREDINTRIP;
	static tCString IMMIDIATEACCELARATIONTIMEINTRIP;
	static tCString WARMUPTIMEINTRIP;
	static tCString MONTHLYFUELINJECTIONQUANTITY;
	static tCString MONTHLYMILEAGECOVERED;
	static tCString MONTHLYFREQUENCYOF4000ROTATIONUSING;
	static tCString MONTHLYFREQUENCYOF6000ROTATIONUSING;
	static tCString DRIVINGTIMEDURINGENTIRELIFETIME;
	static tCString FUELINJECTIONQUANTITYDURINGENTIRELIFETIME;
	static tCString MILEAGEDURINGENTIRELIFETIME;
	static tCString GEOFLAG;
	static tCString INFORMATIONTYPE;
	static tCString LABELSINFO;
	static tCString PROBEINFORMATION;
	static tCString AUTHENTICATIONRESULTDATA; 
	static tCString U8_AUTHENTICATION_RESULT;
	static tCString STR_AUTH_DISPLAY_MESSAGE;
	static tCString STR_AUTH_TTS_MESSAGE;
	static tCString IVIID;
	static tCString MAPVERSION;
	static tCString ITMPROBEVERSION;
	static tCString COMMONINFO;
	
	//JSON Dataypes for EV variant
	static tCString  U32_REQ_ID;
	static tCString  U32_POIID;
	static tCString  U8_SIZE_OF_POI_NAME;
	static tCString  STR_POI_NAME;
	static tCString  STR_AREA_CODE1;
	static tCString  STR_AREA_CODE2;
	static tCString  STR_AREA_CODE3;
	static tCString  STR_AREA_CODE4;
	static tCString  STR_AREA_CODE5;
	static tCString  STR_AREA_CODE6;
	static tCString  STR_AREA_CODE7;
	static tCString  STR_AREA_CODE8;
	static tCString  U8_SIZE_OF_STREET_AND_HOUSE_NO;
	static tCString  STR_STREET_AND_HOUSE_NO;
	static tCString  U16_CATEGORY_CODE;
	static tCString  U16_SUB_CATEGORY_CODE;
	static tCString  U8_SIZE_OF_TELEPHONE_NUMBER;
	static tCString  STR_TELEPHONE_NUMBER;
	static tCString  U8_EXPRESS_WAY_GENERAL_TYPE;
	static tCString  U8_INFORMATION_RELIABILITY;
	static tCString  U8_USER_RESTRICTION;
	static tCString  U32_USER_RESTRICTION_ID;
	static tCString  U8_THE_NUMBER_OF_ENTRANCE_INFORMATION;
	static tCString  U8_ENTRANCE_INFORMATION;
	static tCString  U8_THE_NUMBER_OF_PARTNERS_FACILITY_INFORMATION;
	static tCString  U8_PARTNERS_FACILITY_INFORMATION;
	static tCString  U8_THE_NUMBER_OF_INSTALLATION_FACILITY_INFORMATION;
	static tCString  U8_INSTALLATION_FACILITY_INFORMATION;
	static tCString  U8_THE_TOTAL_NUMBER_OF_CHARGING_TYPE;
	static tCString  U8_CHARGING_TYPE;
	static tCString  U16_PARKING_NUMBER;
	static tCString  U8_FIXED_VALUE_1;
	static tCString  U8_FIXED_VALUE_2;
	static tCString  U16_SIZE_OF_DETAIL_INFORMATION;
	static tCString  U8_DETAILS_INFORMATION;
	static tCString  U8_24_HOURS_A_DAY_INFORMATION;
	static tCString  U8_OFFICE_HOURS_UNKNOWN_INFORMATION;
	static tCString  U8_CHARGING_FEE_INFORMATION;
	static tCString  U8_BUSINESS_DAY_OF_THE_WEEK_INFORMATION;
	static tCString  U16_OPENING_HOUR_INFORMATION;
	static tCString  U16_CLOSED_HOUR_INFORMATION;
	static tCString  U8_NEAR_THE_FACILITY_INFORMATION;
	static tCString  U16_PAYMENT_TYPE_INFORMATION;

	//@rav1hc: chargingSpotData for JPN
	static tCString STR_POI_NAME_FOR_TTS;
	static tCString STR_AREA_NAME1;
	static tCString STR_AREA_NAME2;
	static tCString STR_OOAZA_AND_ADD;
	static tCString U8_USER_LIMIT;
	static tCString U32_USER_LIMIT_ID;
	static tCString ENTRANCE_INFORMATION_LIST;

	static tCString STR_DETAILS_INFORMATION;
	static tCString POI_POSITION_INFORMATION; //POIPositionInformation
	static tCString STR_IDENTIFICATION_NAME;//IdentificationName

	static tCString PARTNERS_FACILITY_INFORMATION_LIST; //PartnersfacilityinformationList
	static tCString PARTNERS_FACILITY;//PartnersFacility
	static tCString STR_PARTNERS_FACILITY_NAME;//strPartnersFacilityName

	static tCString INSTALLATION_FACILITY_INFORMATION_LIST;
	static tCString INSTALLATION_FACILITY_INFORMATION;
	static tCString STR_INSTALLATION_FACILITY_NAME;

	static tCString CHARGING_TYPE_LIST;
	static tCString CHARGING_TYPE;
	static tCString CHARGING_INFOMATION_LIST;
	static tCString U8_CHARGING_METHOD;
	static tCString U8_SET_CONNECTOR_TYPE;
	static tCString U8_THE_NUMBER_OF_CONNECTOR;
		
	static tCString  LIST_OF_CHARGING_STATIONS_HEADER;
	static tCString  U8_POI_DATA_SET_INDENTIFICATION_ID_TYPE;
	static tCString  U32_POI_DATA_SET_INDENTIFICATION_ID;
	static tCString  U32_NUMBER_OF_POI_ID;
	static tCString  U32_POI_ID_VERSION;
	static tCString  CHARGING_STATIONS;
	static tCString  VACANCY_STATIONS;
	static tCString  CHARGING_SPOT_DATA;
	static tCString  POIID_LIST_DATA;
	static tCString  U8_POI_DATASET_IDENTIFICATION_ID_TYPE;
	static tCString  U32_POI_DATASET_IDENTIFICATION_ID;

	//@rav1hc: Vacancy Spot Data
	static tCString  VACANCY_SPOT_DATA;
	static tCString  U8_VACANCY_STATUS;//u8VacancyStatus
	static tCString  U8_NUMBER_OF_AVAILABLE_CONNECTOR;//u8TheNumberOfAvailableConnector
	static tCString  U8_NUMBER_OF_BUSY_CONNECTOR;
	static tCString  U8_NUMBER_OF_UNKNOWN_CONNECTOR;
	static tCString  INFOMATION_PROVISION_TIME;
	static tCString  STR_INFOMATION_PROVIDER;
	static tCString  STR_NETWORK_NAME;
	static tCString  U8_RESERVATION_AVAILABILITY_FLAG;

	static tCString  PART_AUTH_RESPONSE;
	static tCString  PART_AUTH_REQUEST_TYPE;
	static tCString  PART_AUTH_STATUS_CODE;
	static tCString  PART_AUTH_BODY;
	static tCString  PART_AUTH_SN;
	static tCString  PART_AUTH_CERTIFICATE;
	static tCString  PART_AUTH_REGION;
	static tCString  PART_AUTH_PARTITION;
	static tCString  PART_AUTH_ERROR_MESSAGE;
	static tCString  PART_AUTH_ERROR_ID;

	static tCString  USER_AUTH_RESPONSE;
	static tCString  USER_AUTH_REQUEST_TYPE;
	static tCString  USER_AUTH_STATUS_CODE;
	static tCString  USER_AUTH_BODY;
	static tCString  USER_AUTH_ACCESS_TOKEN;
	static tCString  USER_AUTH_REFRESH_TOKEN;
	static tCString  USER_AUTH_SCOPE;
	static tCString  USER_AUTH_ID_TOKEN;
	static tCString  USER_AUTH_TOKEN_TYPE;
	static tCString  USER_AUTH_EXPIRES_IN;
	static tCString  USER_AUTH_DED_ID;
	static tCString  USER_AUTH_ERROR_DESCRIPTION;
	static tCString  USER_AUTH_ERROR;
	static tCString  USER_AUTH_TOKEN;
	static tCString  DECODED_TOKEN_KID;
	
	static tCString  VICS_FILE_PATH;
	
	tBool getJSONObject(Json::Value& input, tCString jsonObjName, Json::Value& output);
	tBool getJSONArray(Json::Value& input, tCString jsonObjName, Json::Value& output);
	tBool getString(Json::Value& input, tCString name, bpstl::string& output);
	tBool gettBool(Json::Value& input, tCString jsonObjName, tBool& output);
	tBool gettU8UInt(Json::Value& input, tCString jsonObjName, tU8& output);
	tBool gettU16UInt(Json::Value& input, tCString jsonObjName, tU16& output);
	tBool gettU32UInt(Json::Value& input, tCString jsonObjName, tU32& output);
	tBool gettU64UInt(Json::Value& input, tCString jsonObjName, tU64& output);
	bpstl::string processingTTSText(bpstl::string originalText);

};

#endif /* JSON_UTILS_H_ */
